/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine.screen.animator;

import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import lib.toma.animations.engine.ByteFlags;
import lib.toma.animations.engine.screen.animator.AbstractImportScreen;
import lib.toma.animations.engine.screen.animator.AnimationProject;
import lib.toma.animations.engine.screen.animator.Animator;
import lib.toma.animations.engine.screen.animator.AnimatorScreen;
import lib.toma.animations.engine.screen.animator.FrameProviderWrapper;
import lib.toma.animations.engine.screen.animator.dialog.DialogScreen;
import lib.toma.animations.engine.screen.animator.dialog.SuggestionResponder;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class MergeAnimationScreen
extends AbstractImportScreen {
    private static final ITextComponent MERGE = new StringTextComponent("Merge into current");
    private final ByteFlags errors = new ByteFlags(0, 1, 2, 3);
    private final Pattern pattern01Dec = Pattern.compile("(1(\\.0+)?)|(0(\\.[0-9]+)?)");
    private TextFieldWidget rangeMin;
    private TextFieldWidget rangeMax;

    public MergeAnimationScreen(AnimatorScreen screen) {
        super(screen);
    }

    @Override
    protected void placeControlButtons(int totalButtonWidth, int buttonWidth) {
        int controlY = this.field_230709_l_ - 25;
        int rangeY = this.field_230709_l_ - 50;
        this.rangeMin = (TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, 5, rangeY, buttonWidth, 20, StringTextComponent.field_240750_d_));
        this.rangeMin.func_212954_a((Consumer)new SuggestionResponder("Merge start", this.rangeMin, this::rangeMinChanged));
        this.rangeMax = (TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, 10 + buttonWidth, rangeY, buttonWidth, 20, StringTextComponent.field_240750_d_));
        this.rangeMax.func_212954_a((Consumer)new SuggestionResponder("Merge end", this.rangeMax, this::rangeMaxChanged));
        this.cancel = (Button)this.func_230480_a_((Widget)new Button(5, controlY, buttonWidth, 20, DialogScreen.CANCEL, this::cancelClicked));
        this.confirm = (Button)this.func_230480_a_((Widget)new Button(10 + buttonWidth, controlY, buttonWidth, 20, MERGE, this::confirmClicked));
    }

    @Override
    protected int getPathViewHeight() {
        return 90;
    }

    @Override
    protected void confirmClicked(Button button) {
        Animator animator = Animator.get();
        FrameProviderWrapper wrapper = animator.getWrapper(this.getSelectedPath());
        if (wrapper != null) {
            AnimationProject project = animator.getProject();
            project.getFrameControl().merge(wrapper, this.getMergeStart(), this.getMergeEnd());
        }
        this.showParent();
    }

    @Override
    protected void updatePathDependents(@Nullable String path) {
        if (path == null || path.isEmpty()) {
            this.errors.set(0);
        } else {
            this.errors.clear(0);
        }
        this.updateDependents();
    }

    private void rangeMinChanged(String value) {
        this.rangeChanged(value, this.rangeMin, 1);
    }

    private void rangeMaxChanged(String value) {
        this.rangeChanged(value, this.rangeMax, 2);
    }

    private void rangeChanged(String value, TextFieldWidget widget, int index) {
        if (this.pattern01Dec.matcher(value).matches()) {
            this.errors.clear(index);
            widget.func_146193_g(0xE0E0E0);
        } else {
            this.errors.set(index);
            widget.func_146193_g(0xE00000);
        }
        float min = this.getMergeStart();
        float max = this.getMergeEnd();
        if (min < max) {
            this.errors.clear(3);
        } else {
            this.errors.set(3);
        }
        this.updateDependents();
    }

    private void updateDependents() {
        this.confirm.field_230693_o_ = this.errors.isEmpty();
    }

    private float getMergeStart() {
        return this.getWidgetValue(this.rangeMin);
    }

    private float getMergeEnd() {
        return this.getWidgetValue(this.rangeMax);
    }

    private float getWidgetValue(TextFieldWidget widget) {
        return widget != null ? this.parseFloat(widget.func_146179_b()) : 0.0f;
    }

    private float parseFloat(String value) {
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException nfe) {
            return 0.0f;
        }
    }
}

